%% Popular functions: polynomials
x = [-10:0.1:10];

plot(x,x)
hold on
plot(x,x.^2, 'r')
plot(x,x.^3, 'g')
plot(x,x.^4, 'm')

% 1/x
figure
plot(x,x.^-1, 'm')

% What happens here? (square root)
plot(x,x.^(1/2))
% same as
plot(x,sqrt(x))

%% Popular functions: sine and cosine
close all
plot(x, sin(x))
hold on
plot(x, cos(x), 'r')

% now try the tangens - what's happening here?
plot(x, tan(x), 'g')
% are we using tan() wrong? Try
plot(x, sin(x)./cos(x), 'm')
% it's sampling and the fact that tan() approaches infinity at pi/2

% "shifting the phase"
close
plot(x, cos(x), 'r')
hold on
plot(x, cos(x - pi/2), 'g')

% sometimes you know the value of sine(x) or cosine(x), 
% but you want the angle x
asin(0)
asin(1)
acos(0)
acos(1)
pi/2
% remember: an angle of 2*pi in radians corresponds to 360 degrees
(180/pi)*acos(0)

%% Popular functions: Exponential
close
x = [-3:0.1:3];
plot(x, exp(x))
hold on
plot(x, exp(-x), 'r')

% logarith
figure
plot(x, log(x))
% where do the log-values for negative arguments come from?

%% Combining functions
close

% Gaussian
plot(x, exp(-x.^2))
% play around with it
plot(x, exp(-10*(x-1).^2), 'k')

% "speeding up" and "slowing down" oscillation
% note sampling problems
plot(x, sin(exp(x)))
plot(x, sin(exp(-x)))

% multiplication of functions results in element-wise vector multiplication
plot(exp(-x).*sin(10*x))   % dampened oscillation

%% function in 2 dimensions
% plot a 2D Gaussian
% from
% (http://stackoverflow.com/questions/13658799/plot-a-grid-of-gaussians-with-matlab)

% create abscissa values along x and y dimensions
x=linspace(-3,3,1000);
y=x'; 
% for Matlab, make a 2D grid with all combinations of values
[X,Y]=meshgrid(x,y);
% then compute the function on all these values
z=exp(-(X.^2+Y.^2)/2);

% plot in 2D
imagesc(x,y,z)

% plot in 3D
surf(x,y,z)
shading interp
colorbar

%% make your own function

my_poly(2, [1 1], [1 2]);


%% Convolution
y = zeros(1,1000);
y(500) = 1;
plot(y)
hold on
z = conv(exp(-x.^2), y, 'same');
plot(z)

% add another peak
y(250) = 1;
plot(y);
z = conv(exp(-x.^2), y, 'same');
plot(z)

%% Differentiation and Integration
close

% Differentiation
% check whether the exponential it its own derivative
x = [-3:0.1:3];
plot(x, exp(x))
hold on
% dont' forget scaling with inverse sample distance
plot(x(2:end), diff(10*exp(x)), 'r')

% Integration
x = [1:0.001:2];
trapz(x, x.^2)
% approximately the same as
2.^3/3 - 1.^3/3
% try different step sizes, e.g. 0.1, and see what happens



